from numpy import array

PU_ADDR = {
    "R32": 1162477,
    "P32": 1166573,
    "U31": 1163821,
    "T31": 1165165,
    "N32": 1110701,
    "M32": 1114733,
    "N33": 1112045,
    "M33": 1113389,
    "L33": 1081261,
    "L34": 1085293,
    "P34": 1082605,
    "N34": 1083949,
    "D33": 1029421,
    "C33": 1033517,
    "B32": 1030765,
    "A32": 1032109,
    "E34": 977645,
    "D34": 981677,
    "A34": 978989,
    "A35": 980333,
    "C34": 948205,
    "B34": 952237,
    "A36": 949549,
    "A37": 950893,
    "E32": 894605,
    "F32": 898637,
    "G33": 895949,
    "G32": 897293,
    "F33": 842829,
    "E33": 846861,
    "K33": 844173,
    "J33": 845517,
    "H34": 813325,
    "G34": 817421,
    "K34": 814733,
    "J34": 816077,
    "AU27": 764214,
    "AT27": 762870,
    "AW26": 765558,
    "AV26": 761526,
    "AU26": 712438,
    "AT26": 711094,
    "AR27": 713782,
    "AP27": 709750,
    "AM26": 682998,
    "AL26": 681654,
    "AN27": 684342,
    "AN26": 680246,
    "AE26": 1165141,
    "AD26": 1163797,
    "AA25": 1166549,
    "AB25": 1162453,
    "AC26": 1113365,
    "AC25": 1112021,
    "AK26": 1114709,
    "AJ26": 1110677,
    "AG26": 1083925,
    "AF26": 1082581,
    "AH25": 1085269,
    "AG25": 1081237,
    "AW25": 1030325,
    "AV25": 1028981,
    "AU25": 1031669,
    "AU24": 1027637,
    "AT24": 978549,
    "AR24": 977205,
    "AR25": 979893,
    "AP25": 975861,
    "AN25": 949109,
    "AM25": 947765,
    "AP24": 950453,
    "AN24": 946357,
    "AC24": 897269,
    "AB24": 895925,
    "AF25": 898613,
    "AE25": 894581,
    "AE24": 845493,
    "AD24": 844149,
    "AG24": 846837,
    "AH24": 842805,
    "AK24": 816053,
    "AJ24": 814709,
    "AL24": 817397,
    "AL25": 813301,
    "P25": 1162479,
    "N25": 1166575,
    "U25": 1163823,
    "T25": 1165167,
    "R25": 1110703,
    "R26": 1114735,
    "P26": 1112047,
    "N26": 1113391,
    "M26": 1081263,
    "L26": 1085295,
    "K25": 1082607,
    "J25": 1083951,
    "G24": 1029423,
    "F24": 1033519,
    "H25": 1030767,
    "G25": 1032111,
    "E24": 977647,
    "E25": 981679,
    "D24": 978991,
    "C24": 980335,
    "D25": 948207,
    "C25": 952239,
    "B25": 949551,
    "A25": 950895,
    "U26": 894607,
    "U27": 898639,
    "T27": 895951,
    "R27": 897295,
    "U28": 842831,
    "T28": 846863,
    "N27": 844175,
    "P28": 845519,
    "K27": 813327,
    "J27": 817423,
    "M27": 814735,
    "L27": 816079,
    "G26": 761551,
    "F26": 765583,
    "J26": 762895,
    "H26": 764239,
    "G27": 709775,
    "F27": 713807,
    "E27": 711119,
    "D27": 712463,
    "B26": 680271,
    "A26": 684367,
    "C26": 681679,
    "C27": 683023,
    "V29": 1162478,
    "U29": 1166574,
    "R29": 1163822,
    "P29": 1165166,
    "U30": 1110702,
    "T30": 1114734,
    "N28": 1112046,
    "M29": 1113390,
    "J29": 1081262,
    "J28": 1085294,
    "L28": 1082606,
    "K28": 1083950,
    "F29": 1029422,
    "E28": 1033518,
    "H28": 1030766,
    "G28": 1032110,
    "H29": 977646,
    "G29": 981678,
    "D28": 978990,
    "C28": 980334,
    "B28": 948206,
    "A28": 952238,
    "B29": 949550,
    "A29": 950894,
    "N30": 894606,
    "M30": 898638,
    "R30": 895950,
    "R31": 897294,
    "P31": 842830,
    "N31": 846862,
    "L31": 844174,
    "L30": 845518,
    "K30": 813326,
    "J30": 817422,
    "K31": 814734,
    "J31": 816078,
    "B31": 761550,
    "A31": 765582,
    "D30": 762894,
    "C30": 764238,
    "D31": 709774,
    "C31": 713806,
    "G30": 711118,
    "F30": 712462,
    "E30": 680270,
    "E31": 684366,
    "H31": 681678,
    "G31": 683022,
    "K21": 1162464,
    "J21": 1166560,
    "M20": 1163808,
    "L20": 1165152,
    "K22": 1110688,
    "J22": 1114720,
    "M21": 1112032,
    "L21": 1113376,
    "P22": 1081248,
    "N22": 1085280,
    "N20": 1082592,
    "N21": 1083936,
    "F20": 1029408,
    "E20": 1033504,
    "H20": 1030752,
    "G20": 1032096,
    "G21": 977632,
    "F21": 981664,
    "C20": 978976,
    "C21": 980320,
    "E21": 948192,
    "D21": 952224,
    "B20": 949536,
    "A20": 950880,
    "M23": 894592,
    "L23": 898624,
    "L24": 895936,
    "K24": 897280,
    "J23": 842816,
    "J24": 846848,
    "P23": 844160,
    "N23": 845504,
    "N24": 813312,
    "M24": 817408,
    "T24": 814720,
    "R24": 816064,
    "H23": 761536,
    "G23": 765568,
    "H22": 762880,
    "G22": 764224,
    "F23": 709760,
    "E23": 713792,
    "C22": 711104,
    "D22": 712448,
    "B22": 680256,
    "A22": 684352,
    "B23": 681664,
    "A23": 683008,
}

DRV_STRENGTH_2V5_VAL_16MA = array([1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1])
DRV_STRENGTH_2V5_VAL_12MA = array([1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0])
DRV_STRENGTH_2V5_VAL_8MA = array([0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0])
DRV_STRENGTH_2V5_VAL_4MA = array([1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0])

DRV_STRENGTH_2V5_ADDR = {
    "R32": array(
        [
            1162029,
            1162061,
            1162125,
            1162157,
            1162189,
            1162285,
            1162317,
            1162349,
            1162381,
            1162413,
            1162445,
        ]
    ),
    "P32": array(
        [
            1166125,
            1166157,
            1166221,
            1166253,
            1166285,
            1166381,
            1166413,
            1166445,
            1166477,
            1166509,
            1166541,
        ]
    ),
    "U31": array(
        [
            1163373,
            1163405,
            1163469,
            1163501,
            1163533,
            1163629,
            1163661,
            1163693,
            1163725,
            1163757,
            1163789,
        ]
    ),
    "T31": array(
        [
            1164717,
            1164749,
            1164813,
            1164845,
            1164877,
            1164973,
            1165005,
            1165037,
            1165069,
            1165101,
            1165133,
        ]
    ),
    "N32": array(
        [
            1110253,
            1110285,
            1110349,
            1110381,
            1110413,
            1110509,
            1110541,
            1110573,
            1110605,
            1110637,
            1110669,
        ]
    ),
    "M32": array(
        [
            1114285,
            1114317,
            1114381,
            1114413,
            1114445,
            1114541,
            1114573,
            1114605,
            1114637,
            1114669,
            1114701,
        ]
    ),
    "N33": array(
        [
            1111597,
            1111629,
            1111693,
            1111725,
            1111757,
            1111853,
            1111885,
            1111917,
            1111949,
            1111981,
            1112013,
        ]
    ),
    "M33": array(
        [
            1112941,
            1112973,
            1113037,
            1113069,
            1113101,
            1113197,
            1113229,
            1113261,
            1113293,
            1113325,
            1113357,
        ]
    ),
    "L33": array(
        [
            1080813,
            1080845,
            1080909,
            1080941,
            1080973,
            1081069,
            1081101,
            1081133,
            1081165,
            1081197,
            1081229,
        ]
    ),
    "L34": array(
        [
            1084845,
            1084877,
            1084941,
            1084973,
            1085005,
            1085101,
            1085133,
            1085165,
            1085197,
            1085229,
            1085261,
        ]
    ),
    "P34": array(
        [
            1082157,
            1082189,
            1082253,
            1082285,
            1082317,
            1082413,
            1082445,
            1082477,
            1082509,
            1082541,
            1082573,
        ]
    ),
    "N34": array(
        [
            1083501,
            1083533,
            1083597,
            1083629,
            1083661,
            1083757,
            1083789,
            1083821,
            1083853,
            1083885,
            1083917,
        ]
    ),
    "D33": array(
        [
            1028973,
            1029005,
            1029069,
            1029101,
            1029133,
            1029229,
            1029261,
            1029293,
            1029325,
            1029357,
            1029389,
        ]
    ),
    "C33": array(
        [
            1033069,
            1033101,
            1033165,
            1033197,
            1033229,
            1033325,
            1033357,
            1033389,
            1033421,
            1033453,
            1033485,
        ]
    ),
    "B32": array(
        [
            1030317,
            1030349,
            1030413,
            1030445,
            1030477,
            1030573,
            1030605,
            1030637,
            1030669,
            1030701,
            1030733,
        ]
    ),
    "A32": array(
        [
            1031661,
            1031693,
            1031757,
            1031789,
            1031821,
            1031917,
            1031949,
            1031981,
            1032013,
            1032045,
            1032077,
        ]
    ),
    "E34": array(
        [
            977197,
            977229,
            977293,
            977325,
            977357,
            977453,
            977485,
            977517,
            977549,
            977581,
            977613,
        ]
    ),
    "D34": array(
        [
            981229,
            981261,
            981325,
            981357,
            981389,
            981485,
            981517,
            981549,
            981581,
            981613,
            981645,
        ]
    ),
    "A34": array(
        [
            978541,
            978573,
            978637,
            978669,
            978701,
            978797,
            978829,
            978861,
            978893,
            978925,
            978957,
        ]
    ),
    "A35": array(
        [
            979885,
            979917,
            979981,
            980013,
            980045,
            980141,
            980173,
            980205,
            980237,
            980269,
            980301,
        ]
    ),
    "C34": array(
        [
            947757,
            947789,
            947853,
            947885,
            947917,
            948013,
            948045,
            948077,
            948109,
            948141,
            948173,
        ]
    ),
    "B34": array(
        [
            951789,
            951821,
            951885,
            951917,
            951949,
            952045,
            952077,
            952109,
            952141,
            952173,
            952205,
        ]
    ),
    "A36": array(
        [
            949101,
            949133,
            949197,
            949229,
            949261,
            949357,
            949389,
            949421,
            949453,
            949485,
            949517,
        ]
    ),
    "A37": array(
        [
            950445,
            950477,
            950541,
            950573,
            950605,
            950701,
            950733,
            950765,
            950797,
            950829,
            950861,
        ]
    ),
    "E32": array(
        [
            894157,
            894189,
            894253,
            894285,
            894317,
            894413,
            894445,
            894477,
            894509,
            894541,
            894573,
        ]
    ),
    "F32": array(
        [
            898189,
            898221,
            898285,
            898317,
            898349,
            898445,
            898477,
            898509,
            898541,
            898573,
            898605,
        ]
    ),
    "G33": array(
        [
            895501,
            895533,
            895597,
            895629,
            895661,
            895757,
            895789,
            895821,
            895853,
            895885,
            895917,
        ]
    ),
    "G32": array(
        [
            896845,
            896877,
            896941,
            896973,
            897005,
            897101,
            897133,
            897165,
            897197,
            897229,
            897261,
        ]
    ),
    "F33": array(
        [
            842381,
            842413,
            842477,
            842509,
            842541,
            842637,
            842669,
            842701,
            842733,
            842765,
            842797,
        ]
    ),
    "E33": array(
        [
            846413,
            846445,
            846509,
            846541,
            846573,
            846669,
            846701,
            846733,
            846765,
            846797,
            846829,
        ]
    ),
    "K33": array(
        [
            843725,
            843757,
            843821,
            843853,
            843885,
            843981,
            844013,
            844045,
            844077,
            844109,
            844141,
        ]
    ),
    "J33": array(
        [
            845069,
            845101,
            845165,
            845197,
            845229,
            845325,
            845357,
            845389,
            845421,
            845453,
            845485,
        ]
    ),
    "H34": array(
        [
            812877,
            812909,
            812973,
            813005,
            813037,
            813133,
            813165,
            813197,
            813229,
            813261,
            813293,
        ]
    ),
    "G34": array(
        [
            816973,
            817005,
            817069,
            817101,
            817133,
            817229,
            817261,
            817293,
            817325,
            817357,
            817389,
        ]
    ),
    "K34": array(
        [
            814285,
            814317,
            814381,
            814413,
            814445,
            814541,
            814573,
            814605,
            814637,
            814669,
            814701,
        ]
    ),
    "J34": array(
        [
            815629,
            815661,
            815725,
            815757,
            815789,
            815885,
            815917,
            815949,
            815981,
            816013,
            816045,
        ]
    ),
}

DRV_STRENGTH_SSTL_CLASS1_ADDR = {
    "R32": array(
        [
            1161965,
            1161997,
            1162029,
            1162061,
            1162093,
            1162125,
            1162157,
            1162189,
            1162221,
            1162253,
            1162285,
            1162317,
            1162349,
            1162381,
            1162413,
            1162445,
        ]
    ),
    "P32": array(
        [
            1166061,
            1166093,
            1166125,
            1166157,
            1166189,
            1166221,
            1166253,
            1166285,
            1166317,
            1166349,
            1166381,
            1166413,
            1166445,
            1166477,
            1166509,
            1166541,
        ]
    ),
    "U31": array(
        [
            1163309,
            1163341,
            1163373,
            1163405,
            1163437,
            1163469,
            1163501,
            1163533,
            1163565,
            1163597,
            1163629,
            1163661,
            1163693,
            1163725,
            1163757,
            1163789,
        ]
    ),
    "T31": array(
        [
            1164653,
            1164685,
            1164717,
            1164749,
            1164781,
            1164813,
            1164845,
            1164877,
            1164909,
            1164941,
            1164973,
            1165005,
            1165037,
            1165069,
            1165101,
            1165133,
        ]
    ),
    "N32": array(
        [
            1110189,
            1110221,
            1110253,
            1110285,
            1110317,
            1110349,
            1110381,
            1110413,
            1110445,
            1110477,
            1110509,
            1110541,
            1110573,
            1110605,
            1110637,
            1110669,
        ]
    ),
    "M32": array(
        [
            1114221,
            1114253,
            1114285,
            1114317,
            1114349,
            1114381,
            1114413,
            1114445,
            1114477,
            1114509,
            1114541,
            1114573,
            1114605,
            1114637,
            1114669,
            1114701,
        ]
    ),
    "N33": array(
        [
            1111533,
            1111565,
            1111597,
            1111629,
            1111661,
            1111693,
            1111725,
            1111757,
            1111789,
            1111821,
            1111853,
            1111885,
            1111917,
            1111949,
            1111981,
            1112013,
        ]
    ),
    "M33": array(
        [
            1112877,
            1112909,
            1112941,
            1112973,
            1113005,
            1113037,
            1113069,
            1113101,
            1113133,
            1113165,
            1113197,
            1113229,
            1113261,
            1113293,
            1113325,
            1113357,
        ]
    ),
    "L33": array(
        [
            1080749,
            1080781,
            1080813,
            1080845,
            1080877,
            1080909,
            1080941,
            1080973,
            1081005,
            1081037,
            1081069,
            1081101,
            1081133,
            1081165,
            1081197,
            1081229,
        ]
    ),
    "L34": array(
        [
            1084781,
            1084813,
            1084845,
            1084877,
            1084909,
            1084941,
            1084973,
            1085005,
            1085037,
            1085069,
            1085101,
            1085133,
            1085165,
            1085197,
            1085229,
            1085261,
        ]
    ),
    "P34": array(
        [
            1082093,
            1082125,
            1082157,
            1082189,
            1082221,
            1082253,
            1082285,
            1082317,
            1082349,
            1082381,
            1082413,
            1082445,
            1082477,
            1082509,
            1082541,
            1082573,
        ]
    ),
    "N34": array(
        [
            1083437,
            1083469,
            1083501,
            1083533,
            1083565,
            1083597,
            1083629,
            1083661,
            1083693,
            1083725,
            1083757,
            1083789,
            1083821,
            1083853,
            1083885,
            1083917,
        ]
    ),
    "D33": array(
        [
            1028909,
            1028941,
            1028973,
            1029005,
            1029037,
            1029069,
            1029101,
            1029133,
            1029165,
            1029197,
            1029229,
            1029261,
            1029293,
            1029325,
            1029357,
            1029389,
        ]
    ),
    "C33": array(
        [
            1033005,
            1033037,
            1033069,
            1033101,
            1033133,
            1033165,
            1033197,
            1033229,
            1033261,
            1033293,
            1033325,
            1033357,
            1033389,
            1033421,
            1033453,
            1033485,
        ]
    ),
    "B32": array(
        [
            1030253,
            1030285,
            1030317,
            1030349,
            1030381,
            1030413,
            1030445,
            1030477,
            1030509,
            1030541,
            1030573,
            1030605,
            1030637,
            1030669,
            1030701,
            1030733,
        ]
    ),
    "A32": array(
        [
            1031597,
            1031629,
            1031661,
            1031693,
            1031725,
            1031757,
            1031789,
            1031821,
            1031853,
            1031885,
            1031917,
            1031949,
            1031981,
            1032013,
            1032045,
            1032077,
        ]
    ),
    "E34": array(
        [
            977133,
            977165,
            977197,
            977229,
            977261,
            977293,
            977325,
            977357,
            977389,
            977421,
            977453,
            977485,
            977517,
            977549,
            977581,
            977613,
        ]
    ),
    "D34": array(
        [
            981165,
            981197,
            981229,
            981261,
            981293,
            981325,
            981357,
            981389,
            981421,
            981453,
            981485,
            981517,
            981549,
            981581,
            981613,
            981645,
        ]
    ),
    "A34": array(
        [
            978477,
            978509,
            978541,
            978573,
            978605,
            978637,
            978669,
            978701,
            978733,
            978765,
            978797,
            978829,
            978861,
            978893,
            978925,
            978957,
        ]
    ),
    "A35": array(
        [
            979821,
            979853,
            979885,
            979917,
            979949,
            979981,
            980013,
            980045,
            980077,
            980109,
            980141,
            980173,
            980205,
            980237,
            980269,
            980301,
        ]
    ),
    "C34": array(
        [
            947693,
            947725,
            947757,
            947789,
            947821,
            947853,
            947885,
            947917,
            947949,
            947981,
            948013,
            948045,
            948077,
            948109,
            948141,
            948173,
        ]
    ),
    "B34": array(
        [
            951725,
            951757,
            951789,
            951821,
            951853,
            951885,
            951917,
            951949,
            951981,
            952013,
            952045,
            952077,
            952109,
            952141,
            952173,
            952205,
        ]
    ),
    "A36": array(
        [
            949037,
            949069,
            949101,
            949133,
            949165,
            949197,
            949229,
            949261,
            949293,
            949325,
            949357,
            949389,
            949421,
            949453,
            949485,
            949517,
        ]
    ),
    "A37": array(
        [
            950381,
            950413,
            950445,
            950477,
            950509,
            950541,
            950573,
            950605,
            950637,
            950669,
            950701,
            950733,
            950765,
            950797,
            950829,
            950861,
        ]
    ),
    "E32": array(
        [
            894093,
            894125,
            894157,
            894189,
            894221,
            894253,
            894285,
            894317,
            894349,
            894381,
            894413,
            894445,
            894477,
            894509,
            894541,
            894573,
        ]
    ),
    "F32": array(
        [
            898125,
            898157,
            898189,
            898221,
            898253,
            898285,
            898317,
            898349,
            898381,
            898413,
            898445,
            898477,
            898509,
            898541,
            898573,
            898605,
        ]
    ),
    "G33": array(
        [
            895437,
            895469,
            895501,
            895533,
            895565,
            895597,
            895629,
            895661,
            895693,
            895725,
            895757,
            895789,
            895821,
            895853,
            895885,
            895917,
        ]
    ),
    "G32": array(
        [
            896781,
            896813,
            896845,
            896877,
            896909,
            896941,
            896973,
            897005,
            897037,
            897069,
            897101,
            897133,
            897165,
            897197,
            897229,
            897261,
        ]
    ),
    "F33": array(
        [
            842317,
            842349,
            842381,
            842413,
            842445,
            842477,
            842509,
            842541,
            842573,
            842605,
            842637,
            842669,
            842701,
            842733,
            842765,
            842797,
        ]
    ),
    "E33": array(
        [
            846349,
            846381,
            846413,
            846445,
            846477,
            846509,
            846541,
            846573,
            846605,
            846637,
            846669,
            846701,
            846733,
            846765,
            846797,
            846829,
        ]
    ),
    "K33": array(
        [
            843661,
            843693,
            843725,
            843757,
            843789,
            843821,
            843853,
            843885,
            843917,
            843949,
            843981,
            844013,
            844045,
            844077,
            844109,
            844141,
        ]
    ),
    "J33": array(
        [
            845005,
            845037,
            845069,
            845101,
            845133,
            845165,
            845197,
            845229,
            845261,
            845293,
            845325,
            845357,
            845389,
            845421,
            845453,
            845485,
        ]
    ),
    "H34": array(
        [
            812813,
            812845,
            812877,
            812909,
            812941,
            812973,
            813005,
            813037,
            813069,
            813101,
            813133,
            813165,
            813197,
            813229,
            813261,
            813293,
        ]
    ),
    "G34": array(
        [
            816909,
            816941,
            816973,
            817005,
            817037,
            817069,
            817101,
            817133,
            817165,
            817197,
            817229,
            817261,
            817293,
            817325,
            817357,
            817389,
        ]
    ),
    "K34": array(
        [
            814221,
            814253,
            814285,
            814317,
            814349,
            814381,
            814413,
            814445,
            814477,
            814509,
            814541,
            814573,
            814605,
            814637,
            814669,
            814701,
        ]
    ),
    "J34": array(
        [
            815565,
            815597,
            815629,
            815661,
            815693,
            815725,
            815757,
            815789,
            815821,
            815853,
            815885,
            815917,
            815949,
            815981,
            816013,
            816045,
        ]
    ),
}


# first bit, the checksum is 16 bit long
CHKSUM_ADDR_START = array(
    [
        813696,
        823200,
        851712,
        899232,
        956256,
        984768,
        1032288,
        1041792,
        1089312,
        1117824,
        1165344,
        1174848,
    ]
)

# this was distilled down to the CHKSUM_ADDR_START
CHKSUM_ADDR = {
    "R32": array(
        [
            1165345,
            1165346,
            1165347,
            1165350,
            1165352,
            1165353,
            1165354,
            1165355,
            1165357,
        ]
    ),
    "P32": array(
        [
            1174848,
            1174849,
            1174850,
            1174851,
            1174852,
            1174854,
            1174855,
            1174857,
            1174860,
        ]
    ),
    "U31": array([1165344, 1165345, 1165347, 1165350, 1165351, 1165354, 1165355]),
    "T31": array(
        [
            1165346,
            1165347,
            1165350,
            1165352,
            1165353,
            1165354,
            1165355,
            1165358,
            1165359,
        ]
    ),
    "N32": array([1117825, 1117830, 1117831, 1117834, 1117835, 1117836, 1117838]),
    "M32": array(
        [
            1117826,
            1117827,
            1117829,
            1117830,
            1117831,
            1117833,
            1117834,
            1117835,
            1117836,
            1117838,
            1117839,
        ]
    ),
    "N33": array([1117825, 1117826, 1117827, 1117830, 1117833, 1117837, 1117838]),
    "M33": array([1117826, 1117827, 1117833, 1117834, 1117835, 1117837, 1117839]),
    "L33": array(
        [
            1089313,
            1089314,
            1089316,
            1089317,
            1089318,
            1089320,
            1089321,
            1089322,
            1089324,
        ]
    ),
    "L34": array(
        [
            1089312,
            1089315,
            1089316,
            1089319,
            1089321,
            1089323,
            1089324,
            1089325,
            1089327,
        ]
    ),
    "P34": array([1089316, 1089317, 1089319, 1089321, 1089323, 1089324, 1089327]),
    "N34": array(
        [
            1089312,
            1089314,
            1089315,
            1089317,
            1089318,
            1089320,
            1089323,
            1089324,
            1089325,
            1089326,
            1089327,
        ]
    ),
    "D33": array(
        [
            1032289,
            1032290,
            1032291,
            1032294,
            1032296,
            1032297,
            1032298,
            1032299,
            1032301,
        ]
    ),
    "C33": array(
        [
            1041792,
            1041793,
            1041794,
            1041795,
            1041796,
            1041798,
            1041799,
            1041801,
            1041804,
        ]
    ),
    "B32": array([1032288, 1032289, 1032291, 1032294, 1032295, 1032298, 1032299]),
    "A32": array(
        [
            1032290,
            1032291,
            1032294,
            1032296,
            1032297,
            1032298,
            1032299,
            1032302,
            1032303,
        ]
    ),
    "E34": array([984769, 984774, 984775, 984778, 984779, 984780, 984782]),
    "D34": array(
        [
            984770,
            984771,
            984773,
            984774,
            984775,
            984777,
            984778,
            984779,
            984780,
            984782,
            984783,
        ]
    ),
    "A34": array([984769, 984770, 984771, 984774, 984777, 984781, 984782]),
    "A35": array([984770, 984771, 984777, 984778, 984779, 984781, 984783]),
    "C34": array(
        [956257, 956258, 956260, 956261, 956262, 956264, 956265, 956266, 956268]
    ),
    "B34": array(
        [956256, 956259, 956260, 956263, 956265, 956267, 956268, 956269, 956271]
    ),
    "A36": array([956260, 956261, 956263, 956265, 956267, 956268, 956271]),
    "A37": array(
        [
            956256,
            956258,
            956259,
            956261,
            956262,
            956264,
            956267,
            956268,
            956269,
            956270,
            956271,
        ]
    ),
    "E32": array(
        [899232, 899233, 899236, 899240, 899242, 899243, 899245, 899246, 899247]
    ),
    "F32": array(
        [
            899232,
            899233,
            899234,
            899235,
            899237,
            899240,
            899241,
            899242,
            899243,
            899246,
            899247,
        ]
    ),
    "G33": array([899232, 899235, 899238, 899240, 899242, 899243, 899247]),
    "G32": array([899232, 899234, 899235, 899239, 899242, 899243, 899247]),
    "F33": array([851713, 851716, 851717, 851720, 851722, 851723, 851725]),
    "E33": array([851712, 851713, 851715, 851717, 851726]),
    "K33": array(
        [851712, 851713, 851715, 851717, 851718, 851721, 851723, 851724, 851726]
    ),
    "J33": array(
        [851712, 851714, 851715, 851716, 851717, 851719, 851721, 851722, 851726]
    ),
    "H34": array([813696, 813698, 813699, 813702, 813706, 813707, 813711]),
    "G34": array([823201, 823202, 823203, 823206, 823209, 823213, 823214]),
    "K34": array([823201, 823203, 823207, 823209, 823213, 823214, 823215]),
    "J34": array([823201, 823206, 823207, 823210, 823211, 823212, 823214]),
}
