/******************************************************************************
*                                                                             *
* License Agreement                                                           *
*                                                                             *
* Copyright (c) 2004 Altera Corporation, San Jose, California, USA.           *
* All rights reserved.                                                        *
*                                                                             *
* Permission is hereby granted, free of charge, to any person obtaining a     *
* copy of this software and associated documentation files (the "Software"),  *
* to deal in the Software without restriction, including without limitation   *
* the rights to use, copy, modify, merge, publish, distribute, sublicense,    *
* and/or sell copies of the Software, and to permit persons to whom the       *
* Software is furnished to do so, subject to the following conditions:        *
*                                                                             *
* The above copyright notice and this permission notice shall be included in  *
* all copies or substantial portions of the Software.                         *
*                                                                             *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING     *
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER         *
* DEALINGS IN THE SOFTWARE.                                                   *
*                                                                             *
* This agreement shall be governed in all respects by the laws of the State   *
* of California and by the laws of the United States of America.              *
*                                                                             *
* Altera does not recommend, suggest or require that this reference design    *
* file be used in conjunction or combination with any other product.          *
******************************************************************************/

#include "sys/alt_dma.h"
#include "sys/alt_errno.h"
#include "priv/alt_file.h"

/*
 * The list of registered DMA receive channels.
 */

ALT_LLIST_HEAD(alt_dma_rxchan_list);

/*
 * alt_dma_txchan_open() is used to obtain an "alt_dma_txchan" descriptor for
 * a DMA transmit device. The name is the name of the associated physical
 * device (e.g. "/dev/dma_0").
 *
 * The return value will be NULL on failure, and non-NULL otherwise. 
 */

alt_dma_rxchan alt_dma_rxchan_open (const char* name)
{
  alt_dma_rxchan dev;

  dev = (alt_dma_rxchan) alt_find_dev (name, &alt_dma_rxchan_list);

  if (!dev)
  {
    ALT_ERRNO = ENODEV;
  }

  return dev;
}
