module catapult_test (
							/* Input clocks */
							/* 125MHz LVCMOS 2V5 */
							input wire clk125_in,
							
							/* I2C0 (Temp sensor, EEPROM) */
							inout wire i2c0_scl,
							inout wire i2c0_sda,
							/* I2C1 (IDT PLL) */
							inout wire i2c1_scl,
							inout wire i2c1_sda,
							/* I2C2 (QSFPA SFF-8636) */
							inout wire i2c2_scl,
							inout wire i2c2_sda,
							/* I2C3 (QSFPB SFF-8636) */
							inout wire i2c3_scl,
							inout wire i2c3_sda,
							
							/* LEDs (D8..D1) */
							output wire [8:1] led
							);

		/* PLL0: 125 MHz in; 100 MHz out */
		wire clk100;
		wire pll0_locked;

		altpll0 altpll0_inst (
							.refclk (clk125_in),  // refclk.clk
							.rst (1'b0),          // reset.reset
							.outclk_0 (clk100),   // outclk0.clk
							.locked (pll0_locked) // locked.export
		);
		
		/* I2C signals */
		wire i2c0_scl_oe;
		wire i2c0_sda_oe;
		wire i2c1_scl_oe;
		wire i2c1_sda_oe;
		wire i2c2_scl_oe;
		wire i2c2_sda_oe;
		wire i2c3_scl_oe;
		wire i2c3_sda_oe;
		/* I2C tristate logic */
		assign i2c0_scl = (i2c0_scl_oe) ? 1'b0 : 1'bz;
		assign i2c0_sda = (i2c0_sda_oe) ? 1'b0 : 1'bz;
		assign i2c1_scl = (i2c1_scl_oe) ? 1'b0 : 1'bz;
		assign i2c1_sda = (i2c1_sda_oe) ? 1'b0 : 1'bz;
		assign i2c2_scl = (i2c2_scl_oe) ? 1'b0 : 1'bz;
		assign i2c2_sda = (i2c2_sda_oe) ? 1'b0 : 1'bz;
		assign i2c3_scl = (i2c3_scl_oe) ? 1'b0 : 1'bz;
		assign i2c3_sda = (i2c3_sda_oe) ? 1'b0 : 1'bz;
		
//		source0 source0_inst (
//									.source ({6'd0, i2c_scl_oe, i2c_sda_oe}) // sources.source
//		);
		
		/* Basic NIOS II system */
		nios_basic nios_basic_inst (
							.clk_clk (clk100),                 // clk.clk
							.i2c0_master_sda_in (i2c0_sda),    // i2c0_master.sda_in
							.i2c0_master_scl_in (i2c0_scl),    // .scl_in
							.i2c0_master_sda_oe (i2c0_sda_oe), // .sda_oe
							.i2c0_master_scl_oe (i2c0_scl_oe), // .scl_oe
							.i2c1_master_sda_in (i2c1_sda),    // i2c1_master.sda_in
							.i2c1_master_scl_in (i2c1_scl),    // .scl_in
							.i2c1_master_sda_oe (i2c1_sda_oe), // .sda_oe
							.i2c1_master_scl_oe (i2c1_scl_oe), // .scl_oe
							.i2c2_master_sda_in (i2c2_sda),    // i2c2_master.sda_in
							.i2c2_master_scl_in (i2c2_scl),    // .scl_in
							.i2c2_master_sda_oe (i2c2_sda_oe), // .sda_oe
							.i2c2_master_scl_oe (i2c2_scl_oe), // .scl_oe
							.i2c3_master_sda_in (i2c3_sda),    // i2c3_master.sda_in
							.i2c3_master_scl_in (i2c3_scl),    // .scl_in
							.i2c3_master_sda_oe (i2c3_sda_oe), // .sda_oe
							.i2c3_master_scl_oe (i2c3_scl_oe), // .scl_oe
							.reset_reset_n (1'b1)              // reset.reset_n
		);

endmodule
